package cz.drg.clasificator.writers;

import cz.drg.clasificator.util.HeaderList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


public abstract class BaseWriter implements OutputWriter{
    
    private final String delimiter;

    public BaseWriter(String delimiter) {
        this.delimiter = delimiter;
    }
    
    @Override
    public abstract void writeOutput(List<String> lines);
    
    @Override
    public void writeOutput(HeaderList originalInput, List<List<String>> evaluatedValues) {
        
        List<List<String>> values = originalInput.getValues();
        List<String> cleansedHeaders = values.get(0).stream().map(value -> value.replaceAll("\"", "")).collect(Collectors.toList());
        values.set(0, cleansedHeaders);
        
        int rowIdHeaderColumn = cleansedHeaders.contains("RUN_ID") ? cleansedHeaders.indexOf("RUN_ID") : cleansedHeaders.indexOf("run_id");
        
        
        List<String> rowIds = new ArrayList<>();
        
        values.forEach(row -> {
            String remove = row.remove(rowIdHeaderColumn);
            rowIds.add(remove);
        });
        
        for (int i = 0; i < evaluatedValues.size(); i++) {
            evaluatedValues.get(i).add(rowIds.get(i));
        }
        
        List<String> originalInputRows = stringMatrixToRows(values);
        List<String> evaluatedRows = stringMatrixToRows(evaluatedValues);
        
        writeOutput(concenate(originalInputRows, evaluatedRows));
        
    }

    private List<String> concenate(List<String> lines, List<String> lines2){
        
        int size = lines.size();
        int size2 = lines2.size();
        
        if(size != size2){
            throw new IllegalArgumentException("Input and output has different row count! Input rows: "+size+", Output rows: "+size2);
        }
        
        List<String> concenated = new ArrayList<>();
        
        for (int i = 0; i < size; i++) {
            
            StringBuilder sb = new StringBuilder();
            sb.append(lines.get(i));
            sb.append(delimiter);
            sb.append(lines2.get(i));
            
            concenated.add(sb.toString());
        }
        
        return concenated;
    }
    
    private List<String> stringMatrixToRows(List<List<String>> matrix){
        
        List<String> rows = new ArrayList<>();
        
        for (List<String> row : matrix) {
            rows.add(stringArrayToString(row));
        }
        
        return rows;
    }
    
    private String stringArrayToString(List<String> array){
        StringBuilder builder = new StringBuilder();
        
        for (int i = 0; i < array.size(); i++) {
            builder.append(array.get(i));
            
            if(i != array.size()-1){
                builder.append(delimiter);
            }
        }
        
        return builder.toString();
    }
}
